	subroutine DORDER(iout, idbg, Ne, Nn, Nb, BCe, BCi, BCtype, ie, &
			N_D, order)	! ### new parameters ###
! create a list of the original vs reordered nodes

! ### new parameters ###
! N_D is the total number of D type nodes
!	(output)
! D_node(Nn) is an integer array. on return it holds D type nodes
!	to be allocated in MAIN and passed to INIT and then here
! order(Nn,0:1) is an integer array. on return
!	its 0 column holds the original D type number and 
!	its 1 column holds the reodered D type number
!	to be allocated in MAIN and passed
!	(input and output)

	implicit none
	integer iout, idbg
	integer Ne, Nn, Nb			! array parameters
	integer N_D				! ### new parameter ###
	integer BCe(Nb,3), BCi(Nb)		! BC element and local element face numbers
	integer ie(Ne,5)			! global connectivity array
	integer order(Nn,0:1)			! ### new parameter ###
	character*1 BCtype(Nb)			! BC type ('N' or 'D')

	integer, allocatable :: D_node(:)	! ### new parameter ###
	integer i, e, i1, i2, n

!	write(idbg,'(a)') ' --- DORDER ---'	! ### TEMPORARY ###
	allocate (D_node(Nn))

! reset D_node to 0
	D_node = 0		! use matrix form
	N_D = 0

	do n = 1, Nb
! find nodes with Dirichlet BC
	  if(BCtype(n) .eq. 'D') then
	    e = BCe(n,3)	! BC element number
	    i = BCi(n)		! BC local element face number
	    if     (i .eq. 1) then
	      i1 = ie(e,1)
	      i2 = ie(e,2)
	    else if(i .eq. 2) then
	      i1 = ie(e,2)
	      i2 = ie(e,3)
	    else if(i .eq. 3) then
	      i1 = ie(e,3)
	      i2 = ie(e,4)
	    else if(i .eq. 4) then
	      i1 = ie(e,4)
	      i2 = ie(e,1)
	    endif

! store the Dirichlet BC node numbers and count them
! (if they were not yet stored or counted)
	    if(D_node(i1).eq. 0) then
	      N_D = N_D +1
	      D_node(i1) = i1
	    endif
	    if(D_node(i2).eq. 0) then
	      N_D = N_D +1
	      D_node(i2) = i2
	    endif
	  endif
	enddo		! n

	i1 = 0		! reset the initial non-D type location
	i2 = Nn-N_D	! reset the initial     D type location
	do n = 1, Nn
	  if(D_node(n) .eq. 0) then
! order the non-D type nodes (reorder to the first Nn-N_D locations)
	    i1 = i1 + 1
	    order(n,1) = i1		! reordered
	  else
! order the     D type nodes (reorder to the last     N_D locations)
	    i2 = i2 + 1
	    order(D_node(n),1) = i2	! reordered
	  endif
	enddo		! n

	do n = 1, Nn
	  order(order(n,1),0) = n	! original
	enddo		! n

	deallocate (D_node)

	return
	end

